-- SPAWN MENU v1.2

function openmenu(menu)
    menu:show()
end

if inGame() and isPlaying() then
	-- BODYGUARD MENU SCRIPT
	function lua_run(path)
		local file = io.open(path, "r")
		if file then
		local exe = loadstring(file:read("*all"))
		if exe then
			exe()
		else
			managers.hud:show_hint( { text = "Error" } )
		end
			file:close()
		else
			managers.hud:show_hint( { text = "Error" } )
		end
	end
	if not run then
	lua_run("trainer/settings.lua")
	run = true
	end

	function UnitNetworkHandler:long_dis_interaction( target_unit, amount, aggressor_unit )
	end
	-- INFINITE CONVERTS FUNCTION
	if not _upgradeValueIntimidate then _upgradeValueIntimidate = PlayerManager.upgrade_value end
	function PlayerManager:upgrade_value( category, upgrade, default )
		if category == "player" and upgrade == "convert_enemies" then
			return true
		elseif category == "player" and upgrade == "convert_enemies_max_minions" then
			return 500
		elseif category == "player" and upgrade == "convert_enemies_health_multiplier" then  
			return 0.25
		elseif category == "player" and upgrade == "convert_enemies_damage_multiplier" then
			return 4.5
		else
			return _upgradeValueIntimidate(self, category, upgrade, default)
		end
	end
	-- FOLLOW UNIT FUNCTION
	function FollowUnit()
		local new_objective
		local valid_criminals = {}
		for pl_key, pl_record in pairs( managers.groupai:state():all_player_criminals() ) do
			if pl_record.status ~= "dead" then
			table.insert( valid_criminals, pl_key )
			end
		end
		if #valid_criminals > 0 then
			local follow_unit = managers.groupai:state():all_player_criminals()[ valid_criminals[ math.random( #valid_criminals ) ] ].unit -- pick a random player
			new_objective = { type = "follow", follow_unit = follow_unit, scan = true, is_default = true}
		end
		return new_objective
	end
	-- FOLLOW UNIT FUNCTION
	function CopLogicIdle._chk_relocate( data )
		if data.objective and data.objective.type == "follow" then
			if data.is_converted then
				if TeamAILogicIdle._check_should_relocate( data, data.internal_data, data.objective ) then
					data.objective.in_place = nil
					CopLogicIdle._exit( data.unit, "travel" )
					return true
				end
				return
			end

			local relocate = false
			local follow_unit = data.objective.follow_unit
			local advance_pos = follow_unit:brain() and follow_unit:brain():is_advancing()
			local follow_unit_pos = advance_pos or data.m_pos
			if data.objective.relocated_to and mvector3.equal( data.objective.relocated_to, follow_unit_pos ) then
				-- we have already relocated to this pos
				return
			end

			--if mvector3.distance( follow_unit:movement():m_pos(), follow_unit_pos ) > data.objective.distance then
			--print( "relocating due to distance" )
		relocate = true
		--end

		if not relocate then
			local ray_params = {
			tracker_from = data.unit:movement():nav_tracker(),
			pos_to = follow_unit_pos
			}
			local ray_res = managers.navigation:raycast( ray_params )
			if ray_res then
				--print( "relocating due to obstacle" )
				relocate = true
			end
		end
		if relocate then
			data.objective.in_place = nil
			data.objective.nav_seg = follow_unit:movement():nav_tracker():nav_segment()
			data.objective.relocated_to = mvector3.copy( follow_unit_pos )
			CopLogicBase._exit( data.unit, "travel" )
			return true
			end
		end
	end
	
	-- CHECK NUMBERS
	if not num or type(num) ~= "table" then
		num = {["enemy"] = 1, ["bodyg"] = 1, ["civ"] = 1}
	end
	-- CHECK SPAWN OPTIONS
	if not variant or type(variant) ~= "table" then
		variant = {["enemy"] = "", ["civ"] = "cm_sp_stand_idle"}
	end
	-- CHECK SPAWN POSITION
	spawn_point = managers.network:game():get_next_spawn_point()
	if not spawn_position then
		spawn_position = nil
	end
	if not spawn_posit then
		spawn_posit = 2
	end
	-- CHECK ENEMY FOLLOW FUNC
	if not followenemy then
		followenemy = 2
	end
	-- CHECK BODYGUARD FOLLOW FUNC
	if not followbg then
		followbg = 2
	end
	--------------------------------
	------- SPAWN OPTIONS ----
	--------------------------------
	spwOption = spwOption or function(variantTable)
		variant[variantTable["type"]] = variantTable["name"]
	end
	 
	--[[ UNUSED CIV ANIMATIONS - TODO
	"cm_sp_stand_type", "cm_sp_window_observer", "cm_sp_sit_high_chair", "cm_sp_sit_talk_table", "cm_sp_sit_with_wounded", "cm_sp_recieving_cpr",
	"cm_sp_wounded_lying2", "cm_sp_gives_cpr", "cm_sp_wounded_lying", "cm_sp_accident_scene", "cm_sp_firefighter", "cf_sp_accident_scene", "cf_sp_stand_idle_var1",
	"cf_sp_stand_desk_1m", "cf_sp_stand_desk_1m", "cf_sp_look_window_var1", "cf_sp_sitting_var1", "cf_sp_stand_look_up", "cf_sp_stand_look_down",
	"cf_sp_sit_hands_on_table_talk", "cf_sp_sit_table_hands_in_knee", "cf_sp_sit_high_chair", "cf_sp_window_observer", "cf_sp_stand_type", "cf_sp_sms_phone_var1",
	"cf_sp_smoking_var1", "cf_sp_stand_hands_on_hip_idle", "cf_sp_stand_listen_music", "cf_sp_stand_one_hand_on_hip", "cf_sp_stand_talk_normal",
	"cf_sp_stand_talk_upset", "cf_sp_stand_talk_calm", "cf_sp_stand_arms_crossed", "cf_sp_lean_bar_desk", "cf_sp_lean_wall_right",]]--
	--------------------------------
	---------- SETTINGS ------------
	--------------------------------
	-- SPAWN ON SELF
	setSelf = setSelf or function()
		spawn_posit = 1
	end
	-- SPAWN ON CROSSHAIR
	setMouse = setMouse or function()
		spawn_posit = 2
	end
	-- SPAWN ON SPAWN POINT
	setSpawnPoint = setSpawnPoint or function()
			spawn_posit = 3
	end
	-- ENEMY FOLLOW FUNC
	setEnemyFollow = setEnemyFollow or function()
		if followenemy == 2 then
			followenemy = 1
			managers.hud:show_hint( { text = "ENEMY FOLLOW ON" } )
		else
			followenemy = 2
			managers.hud:show_hint( { text = "ENEMY FOLLOW OFF" } )
		end
	end
	-- BG FOLLOW FUNC
	setBGFollow = setBGFollow or function()
		if followbg == 2 then
			followbg = 1
			managers.hud:show_hint( { text = "BODYGUARD FOLLOW ON" } )
		else
			followbg = 2
			managers.hud:show_hint( { text = "BODYGUARD FOLLOW OFF" } )
		end
	end
	------------------------------------
	-- AMOUNT OF UNITS TO SPAWN --
	------------------------------------
	-- Any Unit
	setNum = setNum or function(numTable)
		num[numTable["type"]] = numTable["amount"]
	end
	 
	-- SAVE
	setSaveAll = setSaveAll or function()
		local fh = io.open( "trainer/assets/settings.lua", "w" )
		fh:write( "num = ", num["enemy"], "\nvariant = '", variant["enemy"], "'\nnumbg = ", num["bodyg"], "\nspawn_posit = ", spawn_posit, "\nfollowenemy = ", followenemy, "\nfollowbg = ", followbg, "\nvariant2 = '", variant["civ"], "'\nnumciv = ", num["civ"], "\n" )
		io.close( fh )
	end
	--------------------------------
	------- BODYGUARD COPS ---------
	--------------------------------
	-- SPAWN COP FUNCTION
	function SpawnCop(name)
		local spawn_pos = managers.player:player_unit():position()
		local spawn_rot = managers.player:player_unit():rotation()
		local unit_name = Idstring( "units/payday2/characters/" .. name .. "/" .. name)
		local myobjective = FollowUnit()
		local spawn_ai = { init_state = "idle", objective = myobjective }
		local unit = World:spawn_unit( unit_name, spawn_pos, spawn_rot )
		unit:movement():set_character_anim_variables()
		unit:remove_interact()
		unit:set_active(true)
		
		if followbg == 1 then 
			unit:brain():set_spawn_ai( spawn_ai ) 
		end
		managers.groupai:state():convert_hostage_to_criminal( unit )
		managers.groupai:state():sync_converted_enemy( unit )
		--managers.game_play_central:add_friendly_contour( unit )
	end

	-- SPAWN DLC1 COP FUNCTION
	function SpawnDLCop(name)
		local spawn_pos = managers.player:player_unit():position()
		local spawn_rot = managers.player:player_unit():rotation()
		local unit_name = Idstring( "units/pd2_dlc1/characters/" .. name .. "/" .. name)
		local myobjective = FollowUnit()
		local spawn_ai = { init_state = "idle", objective = myobjective }
		local unit = World:spawn_unit( unit_name, spawn_pos, spawn_rot )
		unit:movement():set_character_anim_variables()
		unit:remove_interact()
		unit:set_active(true)
		
		if followbg == 1 then 
			unit:brain():set_spawn_ai( spawn_ai ) 
		end
		managers.groupai:state():convert_hostage_to_criminal( unit )
		managers.groupai:state():sync_converted_enemy( unit )
		--managers.game_play_central:add_friendly_contour( unit )
	end
	-- SPAWN DLC 2 COP FUNCTION
	function SpawnDLCop2(name)
		local spawn_pos = managers.player:player_unit():position()
		local spawn_rot = managers.player:player_unit():rotation()
		local unit_name = Idstring( "units/pd2_dlc2/characters/" .. name .. "/" .. name)
		local myobjective = FollowUnit()
		local spawn_ai = { init_state = "idle", objective = myobjective }
		local unit = World:spawn_unit( unit_name, spawn_pos, spawn_rot )
		unit:movement():set_character_anim_variables()
		unit:remove_interact()
		unit:set_active(true)
		
		if followbg == 1 then 
			unit:brain():set_spawn_ai( spawn_ai ) 
		end
		managers.groupai:state():convert_hostage_to_criminal( unit )
		managers.groupai:state():sync_converted_enemy( unit )
		--managers.game_play_central:add_friendly_contour( unit )
	end
	--------------------------------
	------------ CIVS --------------
	--------------------------------
	-- SPAWN CIV UNIT FUNCTION
	function SpawnCiv(name)
		local camera = managers.player:player_unit():movement()._current_state._ext_camera
		local mvec_to = Vector3()
		local from_pos = camera:position()
		mvector3.set( mvec_to, camera:forward() )
		mvector3.multiply( mvec_to, 20000 )
		mvector3.add( mvec_to, from_pos )
		local col_ray = World:raycast( "ray", from_pos, mvec_to, "slot_mask", managers.slot:get_mask( "bullet_impact_targets" ) )
		if not col_ray then return end
		local spawn_pos = col_ray.hit_position
		local spawn_position = Vector3(spawn_pos.x + (math.random(1,25) * num["civ"]), spawn_pos.y + (math.random() * num["civ"] * 2), spawn_pos.z)
		local spawn_rot = managers.player:player_unit():rotation()
		local unit_name = Idstring( "units/payday2/characters/".. name .."/".. name)
		local unit = World:spawn_unit( unit_name, spawn_position, spawn_rot )
		local action_data = { type = "act", body_part = 1, variant = variant["civ"], clamp_to_graph = true, blocks = { light_hurt = -1, hurt = -1, heavy_hurt = -1, walk = -1 } }
		unit:brain():action_request( action_data )
		unit:set_active(true)
	end
	-- SPAWN DLC CIV UNIT FUNCTION
	function SpawnDLCiv(name)
		local camera = managers.player:player_unit():movement()._current_state._ext_camera
		local mvec_to = Vector3()
		local from_pos = camera:position()
		mvector3.set( mvec_to, camera:forward() )
		mvector3.multiply( mvec_to, 20000 )
		mvector3.add( mvec_to, from_pos )
		local col_ray = World:raycast( "ray", from_pos, mvec_to, "slot_mask", managers.slot:get_mask( "bullet_impact_targets" ) )
		if not col_ray then return end
		local spawn_pos = col_ray.hit_position
		local spawn_position = Vector3(spawn_pos.x + (math.random(1,25) * num["civ"]), spawn_pos.y + (math.random() * num["civ"] * 2), spawn_pos.z)
		local spawn_rot = managers.player:player_unit():rotation()
		local unit_name = Idstring( "units/pd2_dlc1/characters/".. name .."/".. name)
		local unit = World:spawn_unit( unit_name, spawn_position, spawn_rot )
		local action_data = { type = "act", body_part = 1, variant = variant["civ"], clamp_to_graph = true, blocks = { light_hurt = -1, hurt = -1, heavy_hurt = -1, walk = -1 } }
		unit:brain():action_request( action_data )
		unit:set_active(true)
	end
	-- SPAWN DLC2 CIV UNIT FUNCTION
	function SpawnDLCiv2(name)
		local camera = managers.player:player_unit():movement()._current_state._ext_camera
		local mvec_to = Vector3()
		local from_pos = camera:position()
		mvector3.set( mvec_to, camera:forward() )
		mvector3.multiply( mvec_to, 20000 )
		mvector3.add( mvec_to, from_pos )
		local col_ray = World:raycast( "ray", from_pos, mvec_to, "slot_mask", managers.slot:get_mask( "bullet_impact_targets" ) )
		if not col_ray then return end
		local spawn_pos = col_ray.hit_position
		local spawn_position = Vector3(spawn_pos.x + (math.random(1,25) * num["civ"]), spawn_pos.y + (math.random() * num["civ"] * 2), spawn_pos.z)
		local spawn_rot = managers.player:player_unit():rotation()
		local unit_name = Idstring( "units/pd2_dlc2/characters/".. name .."/".. name)
		local unit = World:spawn_unit( unit_name, spawn_position, spawn_rot )
		local action_data = { type = "act", body_part = 1, variant = variant["civ"], clamp_to_graph = true, blocks = { light_hurt = -1, hurt = -1, heavy_hurt = -1, walk = -1 } }
		unit:brain():action_request( action_data )
		unit:set_active(true)
	end
	----------------
	-- MISC UNITS --
	----------------
	function SpawnGang(name)
		local camera = managers.player:player_unit():movement()._current_state._ext_camera
		local mvec_to = Vector3()
		local from_pos = camera:position()
		mvector3.set( mvec_to, camera:forward() )
		mvector3.multiply( mvec_to, 20000 )
		mvector3.add( mvec_to, from_pos )
		local col_ray = World:raycast( "ray", from_pos, mvec_to, "slot_mask", managers.slot:get_mask( "bullet_impact_targets" ) )
		if not col_ray then return end
		if spawn_posit == 1 then
			local spawn_pos = managers.player:player_unit():position()
			spawn_position = Vector3(spawn_pos.x + (math.random(1,25) * num["enemy"]), spawn_pos.y + (math.random() * num["enemy"] * 2), spawn_pos.z)
		elseif spawn_posit == 2 then
			local spawn_pos = col_ray.hit_position
			spawn_position = Vector3(spawn_pos.x + (math.random(1,25) * num["enemy"]), spawn_pos.y + (math.random() * num["enemy"] * 2), spawn_pos.z)
			else
			local spawn_pos = spawn_point.pos_rot[1]
			spawn_position = Vector3(spawn_pos.x + (math.random(1,25) * num["enemy"]), spawn_pos.y + (math.random() * num["enemy"] * 2), spawn_pos.z)
		end
		local spawn_rot = managers.player:player_unit():rotation()
		local unit_name = Idstring( "units/payday2/characters/"..name .."/".. name )
		local myobjective = FollowUnit()
		local spawn_ai = { init_state = "idle", objective = myobjective }
		local unit = World:spawn_unit( unit_name, spawn_position, spawn_rot )
		local action_data = { type = "act", body_part = 1, variant = variant["enemy"], clamp_to_graph = true, blocks = { light_hurt = -1, hurt = -1, heavy_hurt = -1, walk = -1 } }
		unit:brain():action_request( action_data )
		if followenemy == 1 then 
			unit:brain():set_spawn_ai( spawn_ai ) 
		end
		unit:movement():set_character_anim_variables()
	end
	--------------------------------
	------- HOSTILE COPS -----------
	--------------------------------
	-- SPAWN PISSED OFF COP FUNCTION
	function SpawnPissedOfCop(name)
		local camera = managers.player:player_unit():movement()._current_state._ext_camera
		local mvec_to = Vector3()
		local from_pos = camera:position()
		mvector3.set( mvec_to, camera:forward() )
		mvector3.multiply( mvec_to, 20000 )
		mvector3.add( mvec_to, from_pos )
		local col_ray = World:raycast( "ray", from_pos, mvec_to, "slot_mask", managers.slot:get_mask( "bullet_impact_targets" ) )
		if not col_ray then return end
		if spawn_posit == 1 then
			local spawn_pos = managers.player:player_unit():position()
			spawn_position = Vector3(spawn_pos.x + (math.random(1,25) * num["enemy"]), spawn_pos.y + (math.random() * num["enemy"] * 2), spawn_pos.z)
		elseif spawn_posit == 2 then
			local spawn_pos = col_ray.hit_position
			spawn_position = Vector3(spawn_pos.x + (math.random(1,25) * num["enemy"]), spawn_pos.y + (math.random() * num["enemy"] * 2), spawn_pos.z)
			else
			local spawn_pos = spawn_point.pos_rot[1]
			spawn_position = Vector3(spawn_pos.x + (math.random(1,25) * num["enemy"]), spawn_pos.y + (math.random() * num["enemy"] * 2), spawn_pos.z)
		end
		local spawn_rot = managers.player:player_unit():rotation()
		local unit_name = Idstring( "units/payday2/characters/".. name .."/".. name )
		local myobjective = FollowUnit()
		local spawn_ai = { init_state = "idle", objective = myobjective }
		local unit = World:spawn_unit( unit_name, spawn_position, spawn_rot )
		local action_data = { type = "act", body_part = 1, variant = variant["enemy"], clamp_to_graph = true, blocks = { light_hurt = -1, hurt = -1, heavy_hurt = -1, walk = -1 } }
		unit:brain():action_request( action_data )
		if followenemy == 1 then 
			unit:brain():set_spawn_ai( spawn_ai ) 
		end
		unit:movement():set_character_anim_variables()
	end
	-- SPAWN PISSED OFF DLC COP FUNCTION
	function SpawnPissedOfDLCop(name)
		local camera = managers.player:player_unit():movement()._current_state._ext_camera
		local mvec_to = Vector3()
		local from_pos = camera:position()
		mvector3.set( mvec_to, camera:forward() )
		mvector3.multiply( mvec_to, 20000 )
		mvector3.add( mvec_to, from_pos )
		local col_ray = World:raycast( "ray", from_pos, mvec_to, "slot_mask", managers.slot:get_mask( "bullet_impact_targets" ) )
		if not col_ray then return end
		if spawn_posit == 1 then
			local spawn_pos = managers.player:player_unit():position()
			spawn_position = Vector3(spawn_pos.x + (math.random(1,25) * num["enemy"]), spawn_pos.y + (math.random() * num["enemy"] * 2), spawn_pos.z)
		elseif spawn_posit == 2 then
			local spawn_pos = col_ray.hit_position
			spawn_position = Vector3(spawn_pos.x + (math.random(1,25) * num["enemy"]), spawn_pos.y + (math.random() * num["enemy"] * 2), spawn_pos.z)
			else
			local spawn_pos = spawn_point.pos_rot[1]
			spawn_position = Vector3(spawn_pos.x + (math.random(1,25) * num["enemy"]), spawn_pos.y + (math.random() * num["enemy"] * 2), spawn_pos.z)
		end
		local spawn_rot = managers.player:player_unit():rotation()
		local unit_name = Idstring( "units/pd2_dlc1/characters/".. name .."/".. name )
		local myobjective = FollowUnit()
		local spawn_ai = { init_state = "idle", objective = myobjective }
		local unit = World:spawn_unit( unit_name, spawn_position, spawn_rot )
		local action_data = { type = "act", body_part = 1, variant = variant["enemy"], clamp_to_graph = true, blocks = { light_hurt = -1, hurt = -1, heavy_hurt = -1, walk = -1 } }
		unit:brain():action_request( action_data )
		if followenemy == 1 then 
			unit:brain():set_spawn_ai( spawn_ai ) 
		end
		unit:movement():set_character_anim_variables()
	end
	-- SPAWN PISSED OFF DLC COP 2 FUNCTION
	function SpawnPissedOfDLCop2(name)
		local camera = managers.player:player_unit():movement()._current_state._ext_camera
		local mvec_to = Vector3()
		local from_pos = camera:position()
		mvector3.set( mvec_to, camera:forward() )
		mvector3.multiply( mvec_to, 20000 )
		mvector3.add( mvec_to, from_pos )
		local col_ray = World:raycast( "ray", from_pos, mvec_to, "slot_mask", managers.slot:get_mask( "bullet_impact_targets" ) )
		if not col_ray then return end
		if spawn_posit == 1 then
			local spawn_pos = managers.player:player_unit():position()
			spawn_position = Vector3(spawn_pos.x + (math.random(1,25) * num["enemy"]), spawn_pos.y + (math.random() * num["enemy"] * 2), spawn_pos.z)
		elseif spawn_posit == 2 then
			local spawn_pos = col_ray.hit_position
			spawn_position = Vector3(spawn_pos.x + (math.random(1,25) * num["enemy"]), spawn_pos.y + (math.random() * num["enemy"] * 2), spawn_pos.z)
			else
			local spawn_pos = spawn_point.pos_rot[1]
			spawn_position = Vector3(spawn_pos.x + (math.random(1,25) * num["enemy"]), spawn_pos.y + (math.random() * num["enemy"] * 2), spawn_pos.z)
		end
		local spawn_rot = managers.player:player_unit():rotation()
		local unit_name = Idstring( "units/pd2_dlc2/characters/".. name .."/".. name )
		local myobjective = FollowUnit()
		local spawn_ai = { init_state = "idle", objective = myobjective }
		local unit = World:spawn_unit( unit_name, spawn_position, spawn_rot )
		local action_data = { type = "act", body_part = 1, variant = variant["enemy"], clamp_to_graph = true, blocks = { light_hurt = -1, hurt = -1, heavy_hurt = -1, walk = -1 } }
		unit:brain():action_request( action_data )
		if followenemy == 1 then 
			unit:brain():set_spawn_ai( spawn_ai ) 
		end
		unit:movement():set_character_anim_variables()
	end

	-- SPAWN NPC FUNCTION
	function SpawnNPC(name)
	end
	--------------------------------
	------- BODYGUARD COPS ---------
	--------------------------------
	-- SPAWN COP
	spwCop = spwCop or function(name)
		if Network:is_server() then
			for i=1,num["bodyg"] do
				SpawnCop(name)
			end
		end
	end
	spwDLCop = spwDLCop or function(name)
		if Network:is_server() then
			for i=1,num["bodyg"] do
				SpawnDLCop(name)
			end
		end
	end
	spwDLCop2 = spwDLCop2 or function(name)
		if Network:is_server() then
			for i=1,num["bodyg"] do
				SpawnDLCop2(name)
			end
		end
	end
	--------------------------------
	------------- CIVS -------------
	--------------------------------
	-- SPAWN CIV
	spwCiv = spwCiv or function(name)
		if Network:is_server() then
			for i=1,num["civ"] do
				SpawnCiv(name)
			end
		end
	end
	spwDLCiv = spwDLCiv or function(name)
		if Network:is_server() then
			for i=1,num["civ"] do
				SpawnDLCiv(name)
			end
		end
	end
	spwDLCiv2 = spwDLCiv2 or function(name)
		if Network:is_server() then
			for i=1,num["civ"] do
				SpawnDLCiv2(name)
			end
		end
	end
	-- SPAWN GANG
	spwGang = spwGang or function(name)
		if Network:is_server() then
			for i=1,num["enemy"] do
				SpawnGang(name)
			end
		end
	end
	-------- HOSTILE COPS ----------
	--------------------------------
	-- SPAWN PISSED OFF COP
	spwPissedOfCop = spwPissedOfCop or function(name)
		if Network:is_server() then
			for i=1,num["enemy"] do
				SpawnPissedOfCop(name)
			end
		end
	end
	-- SPAWN PISSED OFF DLC COP
	spwPissedOfDLCop = spwPissedOfDLCop or function(name)
		if Network:is_server() then
			for i=1,num["enemy"] do
				SpawnPissedOfDLCop(name)
			end
		end
	end
	-- SPAWN PISSED OFF DLC COP 2
	spwPissedOfCop = spwPissedOfCop or function(name)
		if Network:is_server() then
			for i=1,num["enemy"] do
				SpawnPissedOfDLCop2(name)
			end
		end
	end 
	-------------------------------------------
	-- LOAD LEVEL PACKAGES --
	-------------------------------------------
	loadpack = loadpack or function()
	end
	-- LOAD PROPS PACKAGES
	-- SAFEHOUSE MISSIONS PACKAGES PROPS
	loadallsafehouse = loadallsafehouse or function()
		loadsafe()
	end
	loadsafe = loadsafe or function()
		PackageManager:load("packages/safehouse")
		PackageManager:load("levels/narratives/safehouse/world")
		PackageManager:load("levels/narratives/safehouse/world/world")
		PackageManager:load("levels/narratives/safehouse/safehouse_worldmesh/safehouse_worldmesh")
	end
	-- BAIN MISSIONS PACKAGES PROPS
	loadallbain = loadallbain or function()
		loaddiamond()
		loadroberts()
	end
	loaddiamond = loaddiamond or function()
		PackageManager:load( "packages/narr_family" )
		PackageManager:load("levels/narratives/bain/diamond_store/world")
		PackageManager:load("levels/narratives/bain/diamond_store/world/world")
	end
	loadroberts = loadroberts or function()
		PackageManager:load("packages/narr_roberts")
		PackageManager:load("levels/narratives/bain/roberts/world")
		PackageManager:load("levels/narratives/bain/roberts/world/world")
	end
	-- VLAD MISSIONS PACKAGES PROPS
	loadallvlad = loadallvlad or function()
		loadnight()
		loadjewelstore()
		loadmallcrash()
		loadfour()
		loadukrain()
	end
	-- VLAD MISSIONS PACKAGES PROPS
	loadnight = loadnight or function()
		PackageManager:load("packages/vlad_nightclub")
		PackageManager:load("levels/narratives/vlad/nightclub/world")
		PackageManager:load("levels/narratives/vlad/nightclub/world/world")
		PackageManager:load("levels/narratives/vlad/nightclub/nightclub_interior/nightclub_interior")
		PackageManager:load("levels/narratives/vlad/nightclub/pc_only/pc_only")
	end
	loadjewelstore = loadjewelstore or function()
		PackageManager:load("levels/narratives/vlad/jewelry_store/world")
		PackageManager:load("levels/narratives/vlad/jewelry_store/world/world")
	end
	loadmallcrash = loadmallcrash or function()
		PackageManager:load("packages/vlad_mallcrasher")
		PackageManager:load("levels/narratives/vlad/mallcrasher/world")
		PackageManager:load("levels/narratives/vlad/mallcrasher/world/world")
		PackageManager:load("levels/narratives/vlad/mallcrasher/ed3_world/ed3_world")
	end
	loadfour = loadfour or function()
		PackageManager:load("packages/vlad_four_stores")
		PackageManager:load("levels/narratives/vlad/four_stores/world")
		PackageManager:load("levels/narratives/vlad/four_stores/world/world")
	end
	loadukrain = loadukrain or function()
		PackageManager:load("packages/ukrainian_job")
		PackageManager:load("levels/narratives/vlad/ukrainian_job/world")
		PackageManager:load("levels/narratives/vlad/ukrainian_job/world/world")
	end
	-- ELEPHANT MISSIONS PACKAGES PROPS
	loadallelephant = loadallelephant or function()
		loadframe1()
		loadframe2()
		loadframe3()
		loadjungle1()
		loadjungle2()
	end
	loadframe1 = loadframe1 or function()
		PackageManager:load("packages/narr_framing_1")
		PackageManager:load("levels/narratives/e_framing_frame/stage_1/world")
		PackageManager:load("levels/narratives/e_framing_frame/stage_1/world/world")
	end
	loadframe2 = loadframe2 or function()
		PackageManager:load("packages/narr_framing_2")
		PackageManager:load("levels/narratives/e_framing_frame/stage_2/world")
		PackageManager:load("levels/narratives/e_framing_frame/stage_2/world/world")
	end
	loadframe3 = loadframe3 or function()
		PackageManager:load("packages/narr_framing_3")
		PackageManager:load("levels/narratives/e_framing_frame/stage_3/world")
		PackageManager:load("levels/narratives/e_framing_frame/stage_3/world/world")
	end
	loadjungle1 = loadjungle1 or function()
		PackageManager:load("packages/narr_jungle1")
		PackageManager:load("levels/narratives/e_welcome_to_the_jungle/stage_1/world")
		PackageManager:load("levels/narratives/e_welcome_to_the_jungle/stage_1/world/world")
	end
	loadjungle2 = loadjungle2 or function()
		PackageManager:load("packages/narr_jungle2")
		PackageManager:load("levels/narratives/e_welcome_to_the_jungle/stage_2/world")
		PackageManager:load("levels/narratives/e_welcome_to_the_jungle/stage_2/world/world")
	end
	-- HECTOR MISSIONS PACKAGES PROPS
	loadallhector = loadallhector or function()
		loadrats1()
		loadrats2()
		loadrats3()
		loadwatchdog1()
		loadwatchdog2()
		loadfirestart1()
		loadfirestart2()
		loadfirestart3()
	end
	loadrats1 = loadrats1 or function()
		PackageManager:load("packages/narr_alex1")
		PackageManager:load("levels/narratives/h_alex_must_die/stage_1/world")
		PackageManager:load("levels/narratives/h_alex_must_die/stage_1/world/world")
	end
	loadrats2 = loadrats2 or function()
		PackageManager:load("packages/narr_alex2")
		PackageManager:load("levels/narratives/h_alex_must_die/stage_2/world")
		PackageManager:load("levels/narratives/h_alex_must_die/stage_2/world/world")
	end
	loadrats3 = loadrats3 or function()
		PackageManager:load("packages/narr_alex3")
		PackageManager:load("levels/narratives/h_alex_must_die/stage_3/world")
		PackageManager:load("levels/narratives/h_alex_must_die/stage_3/world/world")
	end
	loadwatchdog1 = loadwatchdog1 or function()
		PackageManager:load("packages/narr_watchdogs1")
		PackageManager:load("levels/narratives/h_watchdogs/stage_1/world")
		PackageManager:load("levels/narratives/h_watchdogs/stage_1/world/world")
	end
	loadwatchdog2 = loadwatchdog2 or function()
		PackageManager:load("packages/narr_watchdogs2")
		PackageManager:load("levels/narratives/h_watchdogs/stage_2/world")
		PackageManager:load("levels/narratives/h_watchdogs/stage_2/world/world")
	end
	loadfirestart1 = loadfirestart1 or function()
		PackageManager:load("packages/narr_firestarter1")
		PackageManager:load("levels/narratives/h_firestarter/stage_1/world")
		PackageManager:load("levels/narratives/h_firestarter/stage_1/world/world")
	end
	loadfirestart2 = loadfirestart2 or function()
		PackageManager:load("packages/narr_firestarter2")
		PackageManager:load("levels/narratives/h_firestarter/stage_2/world")
		PackageManager:load("levels/narratives/h_firestarter/stage_2/world/world")
	end
	loadfirestart3 = loadfirestart3 or function()
		PackageManager:load("packages/narr_firestarter3")
		PackageManager:load("levels/narratives/h_firestarter/stage_3/world")
		PackageManager:load("levels/narratives/h_firestarter/stage_3/world/world")
	end
	-- TRANSPORT MISSIONS PACKAGES PROPS
	loadalltrans = loadalltrans or function()
		loadarmfor()
		loadarmcro()
		loadarmpar()
		loadarmfac()
		loadarmhcm()
		loadarmund()
	end
	loadarmfor = loadarmfor or function()
		PackageManager:load("packages/narr_arm_for")
		PackageManager:load("levels/narratives/armadillo/arm_for/world")
		PackageManager:load("levels/narratives/armadillo/arm_for/world/world")
	end
	loadarmcro = loadarmcro or function()
		PackageManager:load("packages/narr_arm_cro")
		PackageManager:load("levels/narratives/armadillo/arm_cro/world")
		PackageManager:load("levels/narratives/armadillo/arm_cro/world/world")
	end
	loadarmpar = loadarmpar or function()
		PackageManager:load("packages/narr_arm_par")
		PackageManager:load("levels/narratives/armadillo/arm_par/world")
		PackageManager:load("levels/narratives/armadillo/arm_par/world/world")
	end
	loadarmfac = loadarmfac or function()
		PackageManager:load("packages/narr_arm_fac")
		PackageManager:load("levels/narratives/armadillo/arm_fac/world")
		PackageManager:load("levels/narratives/armadillo/arm_fac/world/world")
	end
	loadarmhcm = loadarmhcm or function()
		PackageManager:load("packages/narr_arm_hcm")
		PackageManager:load("levels/narratives/armadillo/arm_hcm/world")
		PackageManager:load("levels/narratives/armadillo/arm_hcm/world/world")
	end
	loadarmund = loadarmund or function()
		PackageManager:load("packages/narr_arm_und")
		PackageManager:load("levels/narratives/armadillo/arm_und/world")
		PackageManager:load("levels/narratives/armadillo/arm_und/world/world")
	end
	-- ESCAPE MISSIONS PACKAGES PROPS
	loadallescape = loadallescape or function()
		loadescoverpass()
		loadescstreet()
		loadesccafe()
		loadescgarage()
		loadescpark()
	end
	loadescoverpass = loadescoverpass or function()
		PackageManager:load("packages/escape_overpass")
		PackageManager:load("levels/narratives/escapes/escape_overpass/world")
		PackageManager:load("levels/narratives/escapes/escape_overpass/world/world")
	end
	loadescstreet = loadescstreet or function()
		PackageManager:load("packages/escape_street")
		PackageManager:load("levels/narratives/escapes/escape_street/world")
		PackageManager:load("levels/narratives/escapes/escape_street/world/world")
	end
	loadesccafe = loadesccafe or function()
		PackageManager:load("packages/escape_cafe")
		PackageManager:load("levels/narratives/escapes/escape_cafe/world")
		PackageManager:load("levels/narratives/escapes/escape_cafe/world/world")
	end
	loadesccafeday = loadesccafeday or function()
		PackageManager:load("packages/escape_cafe")
		PackageManager:load("levels/narratives/escapes/escape_cafe_day/world")
		PackageManager:load("levels/narratives/escapes/escape_cafe_day/world/world")
	end
	loadescgarage = loadescgarage or function()
		PackageManager:load("packages/escape_garage")
		PackageManager:load("levels/narratives/escapes/escape_garage/world")
		PackageManager:load("levels/narratives/escapes/escape_garage/world/world")
	end
	loadescpark = loadescpark or function()
		PackageManager:load("packages/escape_park")
		PackageManager:load("levels/narratives/escapes/escape_park/world")
		PackageManager:load("levels/narratives/escapes/escape_park/world/world")
	end
	loadescparkday = loadescparkday or function()
		PackageManager:load("packages/escape_park")
		PackageManager:load("levels/narratives/escapes/escape_park_day/world/world")
		PackageManager:load("levels/narratives/escapes/escape_park_day/world")
	end
	loadbranchbank = loadbranchbank or function()
		--TODO
	end

	-- PREP NEXT/PREVIOUS BUTTONS
	callspawnmainmenu = callspawnmainmenu or function()
		openmenu(spawnmainmenu)
	end
	callcopmenu = callcopmenu or function()
		openmenu(copmenu)
	end
	callfbimenu = callfbimenu or function()
		openmenu(fbimenu)
	end
	callswatmenu = callswatmenu or function()
		openmenu(swatmenu)
	end
	callmixunitsmenu = callmixunitsmenu or function()
		openmenu(mixunitsmenu)
	end
	callhoscopmenu = callhoscopmenu or function()
		openmenu(hoscopmenu)
	end
	callhosfbimenu = callhosfbimenu or function()
		openmenu(hosfbimenu)
	end
	callhoswatmenu = callposwatmenu or function()
		openmenu(hoswatmenu)
	end
	callcivilfmenu = callcivilfmenu or function()
		openmenu(civilfmenu)
	end
	callcivilmmenu = callcivilmmenu or function()
		openmenu(civilmmenu)
	end
	callcivilmmenu2 = callcivilmmenu2 or function()
		openmenu(civilmmenu2)
	end
	callcopanimenu = callcopanimenu or function()
		openmenu(copanimenu)
	end
	callcivanimenu = callcivanimenu or function()
		openmenu(civanimenu)
	end
	callcivanimenu2 = callcivanimenu2 or function()
		openmenu(civanimenu2)
	end
	callcivanimenu3 = callcivanimenu3 or function()
		openmenu(civanimenu3)
	end
	callsettingsmenu = callsettingsmenu or function()
		openmenu(settingsmenu)
	end
	callspawnnumbermenu = callspawnnumbermenu or function()
		openmenu(spawnnumbermenu)
	end
	callspawnnumberbgmenu = callspawnnumberbgmenu or function()
		openmenu(spawnnumberbgmenu)
	end
	callspawnnumbercivmenu = callspawnnumbercivmenu or function()
		openmenu(spawnnumbercivmenu)
	end
	callgangmenu = callgangmenu or function()
		openmenu(gangmenu)
	end
	callloadmenu = callloadmenu or function()
		openmenu(loadmainmenu)
	end
	callsafehousemenu = callsafehousemenu or function()
		openmenu(devsafemenu)
	end
	callvladmenu = callvladmenu or function()
		openmenu(devvladmenu)
	end
	callbainmenu = callbainmenu or function()
		openmenu(devbainmenu)
	end
	callhectormenu = callhectormenu or function()
		openmenu(devhectormenu)
	end
	callelephantmenu = callelephantmenu or function()
		openmenu(develephantmenu)
	end
	callescapemenu = callescapemenu or function()
		openmenu(devescapemenu)
	end
	calltransmenu = calltransmenu or function()
		openmenu(devtransportmenu)
	end
	------------------
	-- MENU CONTENT --
	------------------
	devsafeopt = devsafeopt or {
		{ text = "Back", callback = callloadmenu },
		{ text = "", is_cancel_button = true},	
		{ text = "Safehouse - Home sweet home", callback = loadsafe },
		{ text = "Haunted safehouse - Home evil home (NOT WORKING)", callback = loadevilsafe },
		{},
		{ text = "Load all safehouse packages", callback = loadallsafe },
		}
	devsafemenu = devsafemenu or SimpleMenu:new("SAFEHOUSE PACKAGES", ".. load package", devsafeopt)	
	devvladopt = devvladopt or {
		{ text = "Back", callback = callloadmenu },
		{ text = "", is_cancel_button = true},	
		{ text = "Nightclub - Party on dude", callback = loadnight },
		{ text = "Jewelry store - Ukrainian job", callback = loadukrain },
		{ text = "Jewelry store - Normal jewelry heist", callback = loadjewelstore },
		{ text = "Mallcrasher - Coke is it!", callback = loadmallcrash },
		{ text = "Four stores - Street Robbers", callback = loadfour },
		{},
		{ text = "Load all Vlad packages", callback = loadallvlad },
		}
	devvladmenu = devvladmenu or SimpleMenu:new("VLAD PACKAGES", ".. load package", devvladopt)	
	devbainopt = devbainopt or {
		{ text = "Back", callback = callloadmenu },
		{ text = "", is_cancel_button = true},	
		{ text = "Diamond Heist - Large jewellery store", callback = loaddiamond },
		{ text = "Charlie Santa - CS:GO again", callback = loadroberts },
		{},
		{ text = "Load all Bain packages", callback = loadallbain },
		}
	devbainmenu = devbainmenu or SimpleMenu:new("BAIN PACKAGES", ".. load package", devbainopt)	
	devhectoropt = devhectoropt or {
		{ text = "Back", callback = callloadmenu },
		{ text = "", is_cancel_button = true},	
		{ text = "Rats day 1 - Coke is it!", callback = loadrats1 },
		{ text = "Rats day 2 - Drug exchange", callback = loadrats2 },
		{ text = "Rats day 3 - Blazing bus boys", callback = loadrats3 },
		{},
		{ text = "Watchdogs day 1 - Confined coke mules", callback = loadwatchdog1 },
		{ text = "Watchdogs day 2 - Sitting on the dock of the bay", callback = loadwatchdog2 },
		{},
		{ text = "Firestarter day 1 - Hangar 18", callback = loadfirestart1 },
		{ text = "Firestarter day 2 - FBI Office", callback = loadfirestart2 },
		{ text = "Firestarter day 3 - Electric bank", callback = loadfirestart3 },
		{},
		{ text = "Load all Hector packages", callback = loadallhector },
		}
	devhectormenu = devhectormenu or SimpleMenu:new("HECTOR PACKAGES", ".. load package", devhectoropt)	
	develephantopt = develephantopt or {
		{ text = "Back", callback = callloadmenu },
		{ text = "", is_cancel_button = true},	
		{ text = "Big oil day 1 - Bikers hideout", callback = loadjungle1 },
		{ text = "Big oil day 2 - Engine trouble", callback = loadjungle2 },
		{},
		{ text = "Framing frame day 1 - Mona Lisa awaits", callback = loadframe1 },
		{ text = "Framing frame day 2 - FBI Trainyard ambush", callback = loadframe2 },
		{ text = "Framing frame day 3 - Golden appartment caper", callback = loadframe3 },
		{},
		{ text = "Load all elephant packages", callback = loadallelephant },
		}
	develephantmenu = develephantmenu or SimpleMenu:new("ELEPHANT PACKAGES", ".. load package", develephantopt)	
	devtransopt = devtransopt or {
		{ text = "Back", callback = callloadmenu },
		{ text = "", is_cancel_button = true},	
		{ text = "Downtown", callback = loadarmhcm },
		{ text = "Crossroads", callback = loadarmcro },
		{ text = "Harbor", callback = loadarmfac },
		{ text = "Park", callback = loadarmpar },
		{ text = "Underpass", callback = loadarmund },
		{},	
		{ text = "Train Heist", callback = loadarmfor },
		{},
		{ text = "Load all transport packages", callback = loadalltrans },
		}
	devtransportmenu = devtransportmenu or SimpleMenu:new("ARMOURED TRANSPORT PACKAGES", ".. load transport package\(s\)",devtransopt)
	devescapeopt = devescapeopt or {
		{ text = "Back", callback = callloadmenu },
		{ text = "", is_cancel_button = true},	
		{ text = "Street escape", callback = loadescstreet },
		{ text = "Garage escape", callback = loadescgarage },
		{ text = "Cafe escape", callback = loadesccafe },
		{ text = "Cafe escape day", callback = loadesccafeday },
		{ text = "Park escape", callback = loadescpark },
		{ text = "Park escape day", callback = loadescparkday },
		{ text = "Overpass escape", callback = loadescoverpass },
		{ text = "Overpass escape night", callback = loadescoverpass },
		{},
		{ text = "Load all escape packages", callback = loadallescape },
		}
	devescapemenu = devescapemenu or SimpleMenu:new("ESCAPE PACKAGES", ".. load escape package\(s\)", devescapeopt)
	-- LOAD PACKAGES MAIN MENU
	loadmainopt = loadmainopt or {
		{ text = "Back", callback = calldevrootmenu },
		{ text = "", is_cancel_button = true},
		{ text = "Safehouse missions", callback = callsafehousemenu },
		--{ text = "Load ALL SAFEHOUSE packages", callback = loadallsafe },
		--{ text = "Haunted Safehouse", callback = loadsafe },
		--{ text = "Safehouse", callback = loadsafe },
		{},
		{ text = "Armoured transport missions", callback = calltransmenu },
		{ text = "Load ALL ARMOURED TRANSPORT MISSIONS packages", callback = loadalltrans },
		{},
		{ text = "Escape missions", callback = callescapemenu },
		{ text = "Load ALL ESCAPE MISSIONS packages", callback = loadallescape },
		{},
		{ text = "Elephant missions", callback = callelephantmenu },
		{ text = "Load ALL ELEPHANT packages", callback = loadallelephant },
		{},
		{ text = "Hector missions", callback = callhectormenu },
		{ text = "Load ALL HECTOR packages", callback = loadallhector },
		{},
		{ text = "Vlad missions", callback = callvladmenu },
		{ text = "Load ALL VLAD packages", callback = loadallvlad },
		{},
		{ text = "Bain missions", callback = callbainmenu },
		{ text = "Load ALL BAIN packages", callback = loadallbain },
		--{},
		--{ text = "LOAD ALL PACKAGES FULL AKA THE RAM KILLER", callback = loadallpack },
		--{ text = "LOAD ALL PACKAGES LIGHT", callback = loadlightpack },
		}
	loadmainmenu = loadmainmenu or SimpleMenu:new("THE WAREHOUSE", ".. here be packages",loadmainopt)
	-- SPAWN COP ANIMATION OPTIONS MENU
	copanioptions = copanioptions or {
		{ text = "Back", callback = callspawnmainmenu },
		{ text = "", is_cancel_button = true},
		{ text = "Civilian animations page 1", callback = callcivanimenu },
		{ text = "Civilian animations page 2", callback = callcivanimenu2 },
		{ text = "Civilian animations page 3", callback = callcivanimenu3 },
		{},
		{ text = "No animation", callback = spwOption, data = {["type"] = "enemy", ["name"] = ""} }, -- None
		{},
		{ text = "Car exit", callback = spwOption, data = {["type"] = "enemy", ["name"] = "e_sp_car_exit_to_cbt_front_l"} }, -- optCarExitL
		{ text = "Jump down from helicopter", callback = spwOption, data = {["type"] = "enemy", ["name"] = "e_sp_jump_down_heli_cbt_right"} }, -- optHeliR
		{ text = "Hurt from truck", callback = spwOption, data = {["type"] = "enemy", ["name"] = "e_sp_hurt_from_truck"} }, -- optHurtFT
		{ text = "Down 17m", callback = spwOption, data = {["type"] = "enemy", ["name"] = "e_sp_down_17m"} }, -- optD17
		{ text = "Up 1m down 9m", callback = spwOption, data = {["type"] = "enemy", ["name"] = "e_sp_up_1_down_9_25m"} }, -- optU1D9
		{ text = "Up 2m down 1m", callback = spwOption, data = {["type"] = "enemy", ["name"] = "e_sp_up_2_75_down_1_25m"} }, -- optU2D1
		{ text = "Repel into window", callback = spwOption, data = {["type"] = "enemy", ["name"] = "e_sp_repel_into_window"} }, -- optRepelIW
		{ text = "Down 16m", callback = spwOption, data = {["type"] = "enemy", ["name"] = "e_sp_down_16m_right"} }, -- optDown16
		{ text = "Slide 4m", callback = spwOption, data = {["type"] = "enemy", ["name"] = "e_nl_slide_fwd_4m"} }, -- optSl4
		{ text = "Up 1 fwd 5m", callback = spwOption, data = {["type"] = "enemy", ["name"] = "e_nl_up_1_fwd_1_5m_var2"} }, -- optSl4
		-- { text = "UNKOWN", callback = spwOption, data = {["type"] = "enemy", ["name"] = "e_sp_down_12m_var2"} }, -- optDown12v2
		}
	copanimenu = copanimenu or SimpleMenu:new("COP ANIMATION OPTIONS", "..how should the cop appear.",copanioptions)
	-- SPAWN CIV ANIMATION OPTIONS MENU
	civanioptions = civanioptions or {
		{ text = "Back", callback = callspawnmainmenu },
		{ text = "", is_cancel_button = true},
		{ text = "Civilian animations page 2", callback = callcivanimenu2 },
		{ text = "Civilian animations page 3", callback = callcivanimenu3 },
		{ text = "Cop animations", callback = callcopanimenu },
		{},
		{ text = "No animations", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_stand_idle"} }, -- opt2None
		{},
		{ text = "DJ'ing", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_dj_loop"} }, -- opt2dj
		{ text = "Dance slow", callback = spwOption, data = {["type"] = "civ", ["name"] = "cf_sp_dance_slow"} }, -- opt2DSlow
		{ text = "Dance sexy", callback = spwOption, data = {["type"] = "civ", ["name"] = "cf_sp_dance_sexy"} }, -- opt2DSexy
		{ text = "Pole dancer basic", callback = spwOption, data = {["type"] = "civ", ["name"] = "cf_sp_pole_dancer_basic"} }, -- opt2PDBasic
		{ text = "Pole dancer expert", callback = spwOption, data = {["type"] = "civ", ["name"] = "cf_sp_pole_dancer_expert"} }, -- opt2PDExpert
		{ text = "Male stripper", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_male_stripper"} }, -- opt2ms
		{ text = "Sit idle", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_sit_idle1"} }, -- opt2anim32
		{ text = "Sit table", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_sit_table_var1_01"} }, -- opt2anim17
		{ text = "Sit table 2", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_sit_table_var2_01"} }, -- opt2anim18
		{ text = "Sit table normal", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_sit_normal_table"} }, -- opt2anim11
		{ text = "Sit feet table", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_sit_feet_table"} }, -- opt2anim37
		{ text = "Sit legs crossed", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_sit_legs_crossed"} }, -- opt2anim12
		{ text = "Sit legs crossed 2", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_sit_legs_crossed_var2"} }, -- opt2anim33
		}
	civanimenu = civanimenu or SimpleMenu:new("CIVS ANIMATION OPTIONS", ".. street party yo!",civanioptions)
	civanioptions2 = civanioptions2 or {
		{ text = "Back", callback = callspawnmainmenu },
		{ text = "", is_cancel_button = true},
		{ text = "Civilian animations page 1", callback = callcivanimenu },
		{ text = "Civilian animations page 3", callback = callcivanimenu3 },
		{ text = "Cop animations", callback = callcopanimenu },
		{},
		{ text = "Lean desk 2m", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_lean_desk_1_2m_01"} },
		{ text = "Lean wall", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_lean_wall1"} },
		{ text = "Lean wall right", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_lean_wall_right"} },
		{ text = "Lean wall back", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_lean_wall_right"} }, -- <- Something wrong here? - They were both the same!
		{ text = "Lean wall assist", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_lean_wall_ass1"} },
		{ text = "Stand waiting", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_stand_waiting"} },
		{ text = "Stand arms crossed", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_stand_arms_crossed"} },
		{ text = "Standing idle", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_standing_idle_var2"} },
		{ text = "Standing talk", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_standing_talk1"} },
		{ text = "Smoking left", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_smoking_left1"} },
		{ text = "Smoking right", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_smoking_right1"} },
		{ text = "Look semi down", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_look_look_semi_down"} },
		{ text = "Look window", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_look_window"} },
		}
	civanimenu2 = civanimenu2 or SimpleMenu:new("CIVS ANIMATION OPTIONS", ".. page two",civanioptions2)
	civanioptions3 = civanioptions3 or {
		{ text = "Back", callback = callspawnmainmenu },
		{ text = "", is_cancel_button = true},
		{ text = "Civilian animations page 1", callback = callcivanimenu },
		{ text = "Civilian animations page 2", callback = callcivanimenu2 },
		{ text = "Cop animations", callback = callcopanimenu },
		{},
		{ text = "Talking upset", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_talking_upset"} },
		{ text = "Talking normal", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_talking_normal"} },
		{ text = "Phone", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_phone1"} },
		{ text = "Phone 2", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_phone2"} },
		{ text = "Waiting sway", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_waiting_sway"} },
		{ text = "Bar standing", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_bar_standing"} },
		{ text = "Lying hurt", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_stand_waiting"} },
		{ text = "Drunk idle", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_drunk_idle"} },
		{ text = "Stretch", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_stretch1"} },
		{ text = "Listen music idle", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_listen_music_idle"} },
		{ text = "One hand on hip", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_one_hand_on_hip"} },
		{ text = "Hands on hip", callback = spwOption, data = {["type"] = "civ", ["name"] = "cm_sp_hands_on_hip" } },
		}
	civanimenu3 = civanimenu3 or SimpleMenu:new("CIVS ANIMATION OPTIONS", ".. page three",civanioptions3)
	-- MIXED UNITS MENU INGAME
	mixunits = mixunits or {
		{ text = "Back", callback = callspawnmainmenu },
		{ text = "", is_cancel_button = true},
		{ text = "COP bodyguard menu", callback = callcopmenu },
		{ text = "FBI bodyguard menu", callback = callfbimenu },
		{ text = "SWAT bodyguard menu", callback = callswatmenu },
		}	
	mixunitsmenu = mixunitsmenu or SimpleMenu:new("SPAWN ASSORTED UNITS", "don't forget to load package when testing",mixunits)
	-- FRIENDLY COP UNITS MENU INGAME
	copoptions = copoptions or {
		{ text = "Back", callback = callspawnmainmenu },
		{ text = "", is_cancel_button = true},
		{ text = "FBI bodyguard menu", callback = callfbimenu },
		{ text = "SWAT bodyguard menu", callback = callswatmenu },
		{},
		{ text = "Gun", callback = spwCop, data = "ene_cop_1" },
		{ text = ".45 Gun", callback = spwCop, data = "ene_cop_2" },
		{ text = "Smg", callback = spwCop, data = "ene_cop_3" },
		{ text = "Shotgun", callback = spwCop, data = "ene_cop_4" },
		{ text = "Mallcop gun", callback = spwCop, data = "ene_security_1" },
		{ text = "Mallcop smg", callback = spwCop, data = "ene_security_2" },
		{ text = "Mallcop gun armor", callback = spwCop, data = "ene_security_3" },
		{ text = "Secret service", callback = spwCop, data = "ene_secret_service_1" },
		{ text = "Secret service 2", callback = spwCop, data = "ene_secret_service_2" },
		{ text = "GenSec Security officer", callback = spwDLCop, data = "ene_security_gensec_1" },
		{ text = "GenSec Security officer 2", callback = spwDLCop, data = "ene_security_gensec_2" },
		}
	copmenu = copmenu or SimpleMenu:new("SPAWN COP BODYGUARD UNITS", "Call in the donuts.",copoptions)
	-- FRIENDLY FBI UNITS MENU INGAME
	fbioptions = fbioptions or {
		{ text = "Back", callback = callspawnmainmenu },
		{ text = "", is_cancel_button = true},
		{ text = "COP bodyguard menu", callback = callcopmenu },
		{ text = "SWAT bodyguard menu", callback = callswatmenu },
		{},
		{ text = "Gun", callback = spwCop, data = "ene_fbi_1" },
		{ text = "Smg", callback = spwCop, data = "ene_fbi_2" },
		{ text = "Assault", callback = spwCop, data = "ene_fbi_3" },
		{ text = "Heavy assault", callback = spwCop, data = "ene_fbi_heavy_1" },
		{ text = "Heavy assault 2", callback = spwCop, data = "ene_fbi_swat_1" },
		{ text = "Heavy shotgun", callback = spwCop, data = "ene_fbi_swat_2" },
		{ text = "Shield", callback = spwCop, data = "ene_shield_1" },
		{ text = "Sniper", callback = spwCop, data = "ene_sniper_2" },
		}
	fbimenu = fbimenu or SimpleMenu:new("SPAWN FBI BODYGUARD UNITS", "Call in the cavalry.",fbioptions)
	-- FRIENDLY SWAT UNITS MENU INGAME
	swatoptions = swatoptions or {
		{ text = "Back", callback = callspawnmainmenu },
		{ text = "", is_cancel_button = true},
		{ text = "COP bodyguard menu", callback = callcopmenu },
		{ text = "FBI bodyguard menu", callback = callfbimenu },
		{},
		{ text = "Smg", callback = spwCop, data = "ene_swat_1" },
		{ text = "Urban camo SMG", callback = spwCop, data = "ene_city_swat_3" },
		{ text = "Shotgun", callback = spwCop, data = "ene_swat_2" },
		{ text = "Urban camo shotgun", callback = spwCop, data = "ene_city_swat_2" },
		{ text = "Assault", callback = spwCop, data = "ene_swat_heavy_1" },
		{ text = "Urban camo assault", callback = spwCop, data = "ene_city_swat_1" },
		{ text = "Tazer", callback = spwCop, data = "ene_tazer_1" },
		{ text = "Spook", callback = spwCop, data = "ene_spook_1" },
		{ text = "Shield", callback = spwCop, data = "ene_shield_2" },
		{ text = "Sniper", callback = spwCop, data = "ene_sniper_1" },
		{ text = "Bulldozer", callback = spwCop, data = "ene_bulldozer_1" },
		{ text = "Saiga bulldozer", callback = spwCop, data = "ene_bulldozer_2" },
		{ text = "Urban camo bulldozer", callback = spwCop, data = "ene_bulldozer_3" },
		}
	swatmenu = swatmenu or SimpleMenu:new("SPAWN SWAT BODYGUARD UNITS", "Call in the big guns.",swatoptions)
	-- CIVILIAN FEMALE UNITS MENU
	civilfoptions = civilfoptions or {
		{ text = "Back", callback = callspawnmainmenu },
		{ text = "", is_cancel_button = true},
		{ text = "Male Civilians \[MENU\]", callback = callcivilmmenu },
		{ text = "Male Civilians 2 \[MENU\]", callback = callcivilmmenu2 },
		{},
		{ text = "Casual ( Works on a majority of maps)", callback = spwCiv, data = "civ_female_casual_1" },
		{ text = "Casual 2", callback = spwCiv, data = "civ_female_casual_2" },
		{ text = "Casual 4", callback = spwCiv, data = "civ_female_casual_4" },
		{ text = "Casual 5", callback = spwCiv, data = "civ_female_casual_5" },
		{ text = "Crackwhore", callback = spwCiv, data = "civ_female_crackwhore_1" },
		{ text = "Hostess apron", callback = spwCiv, data = "civ_female_hostess_apron_1" },
		{ text = "Hostess jacket", callback = spwCiv, data = "civ_female_hostess_jacket_1" },
		{ text = "Hostess shirt", callback = spwCiv, data = "civ_female_hostess_shirt_1" },
		{ text = "Female bank worker", callback = spwCiv, data = "civ_female_bank_1" },
		{ text = "Female bank assistant", callback = spwDLCiv, data = "civ_female_bank_assistant_1" },
		{ text = "Female bank assistant 2", callback = spwDLCiv, data = "civ_female_bank_assistant_2" },
		{ text = "Bank manager", callback = spwCiv, data = "civ_female_bank_manager_1" },
		{ text = "Party", callback = spwCiv, data = "civ_female_party_1" },
		{ text = "Party 2", callback = spwCiv, data = "civ_female_party_2" },
		{ text = "Party 3", callback = spwCiv, data = "civ_female_party_3" },
		{ text = "Party 4", callback = spwCiv, data = "civ_female_party_4" },
		{ text = "Trophy Wife", callback = spwCiv, data = "civ_female_wife_trophy_1" },
		{ text = "Trophy Wife 2", callback = spwCiv, data = "civ_female_wife_trophy_2" },
		--{ text = "Casual 3 (NOT WORKING?)", callback = spwCiv5 },
		--{ text = "Bikini (DOES NOTHING)", callback = spwCiv1 },
		--{ text = "Bikini 2 (NOT WORKING?)", callback = spwCiv2 },
		}
	civilfmenu = civilfmenu or SimpleMenu:new("SPAWN FEMALE CIVILIAN UNITS", "Call in the boobs",civilfoptions)
	 -- CIVILIAN MALE UNITS MENU
	civilmoptions = civilmoptions or {
		{ text = "Back", callback = callspawnmainmenu },
		{ text = "", is_cancel_button = true},
		{ text = "Female Civilians \[MENU\]", callback = callcivilfmenu },
		{ text = "Male Civilians 2\[MENU\]", callback = callcivilmmenu2 },
		{},
		{ text = "Bank", callback = spwCiv, data = "civ_male_bank_1" },
		{ text = "Bank 2", callback = spwCiv, data = "civ_male_bank_2" },
		{ text = "Bank manager", callback = spwCiv, data = "civ_male_bank_manager_1" },
		{ text = "Bank manager 2", callback = spwDLCiv, data = "civ_male_bank_manager_2" },
		{ text = "Business", callback = spwCiv, data = "civ_male_business_1" },
		{ text = "Business 2", callback = spwCiv, data = "civ_male_business_2" },
		{ text = "Casual (Works on the majority of maps)", callback = spwCiv, data = "civ_male_casual_1" },
		{ text = "Casual 2", callback = spwCiv, data = "civ_male_casual_2" },
		{ text = "Casual 3", callback = spwCiv, data = "civ_male_casual_3" },
		{ text = "Casual 4", callback = spwCiv, data = "civ_male_casual_4" },
		{ text = "Casual 5", callback = spwCiv, data = "civ_male_casual_5" },
		{ text = "Casual 6", callback = spwCiv, data = "civ_male_casual_6" },
		--{ text = "Casual 7 (NOT WORKING)", callback = spwCiv31 },
		--{ text = "Casual 8 (NOT WORKING)", callback = spwCiv32 },
		{ text = "Casual 9", callback = spwCiv, data = "civ_male_casual_9" },-- 33
		{ text = "Casual 10", callback = spwDLCiv, data = "civ_male_casual_10" },-- 33
		{ text = "Casual 11", callback = spwDLCiv, data = "civ_male_casual_11" },-- 33
		}
	civilmmenu = civilmmenu or SimpleMenu:new("SPAWN MALE CIVILIAN UNITS", "Call in the noobs",civilmoptions)
	civilmoptions2 = civilmoptions2 or {
		{ text = "Back", callback = callspawnmainmenu },
		{ text = "", is_cancel_button = true},
		{ text = "Female Civilians \[MENU\]", callback = callcivilfmenu },
		{ text = "Male Civilians 1\[MENU\]", callback = callcivilmmenu },
		{},
		{ text = "DJ", callback = spwCiv, data = "civ_male_dj_1" }, -- 34
		{ text = "Meth cook", callback = spwCiv, data = "civ_male_meth_cook_1" }, -- 37
		{ text = "Party", callback = spwCiv, data = "civ_male_party_1" }, -- 40
		{ text = "Party 2", callback = spwCiv, data = "civ_male_party_2" }, -- 41
		{ text = "Party 3", callback = spwCiv, data = "civ_male_party_3" }, -- 42
		{ text = "Scientist", callback = spwCiv, data = "civ_male_scientist_1" }, -- 43
		{ text = "Dock worker 2", callback = spwCiv, data = "civ_male_worker_docks_2" }, -- 46
		{ text = "Dock worker 3", callback = spwCiv, data = "civ_male_worker_docks_1" }, -- 47
		{ text = "Paramedic", callback = spwDLC1, data = "civ_male_paramedic_1" },
		{ text = "Paramedic 2", callback = spwDLC1, data = "civ_male_paramedic_2" },
		{ text = "Firefighter", callback = spwDLC1, data = "civ_male_firefighter_1" },
		--{ text = "Dock worker (NOT WORKING)", callback = spwCiv45 },
		--{ text = "Janitor (NOT WORKING)", callback = spwCiv36 },
		--{ text = "Paramedic (NOT WORKING)", callback = spwCiv38 },
		--{ text = "Paramedic 2 (NOT WORKING)", callback = spwCiv39 },
		--{ text = "Trucker (NOT WORKING)", callback = spwCiv44 },
		--{ text = "Italian Robe - pimp? (NOT WORKING)", callback = spwCiv35 },
		}
	civilmmenu2 = civilmmenu2 or SimpleMenu:new("SPAWN MALE CIVILIAN UNITS 2", "Call in the noobs",civilmoptions2)
	gangoptions = gangoptions or {
		{ text = "Back", callback = callspawnmainmenu },
		{ text = "", is_cancel_button = true},
		{ text = "Hostile COPS menu", callback = callhoscopmenu },
		{ text = "Hostile FBI menu", callback = callhosfbimenu },
		{ text = "Hostile SWAT menu", callback = callhoswatmenu },
		{},
		{ text = "Hoodrat", callback = spwGang, data = "ene_gang_black_1" }, -- 48
		{ text = "G/Gee", callback = spwGang, data = "ene_gang_black_2" }, -- 49
		{ text = "Prapper", callback = spwGang, data = "ene_gang_black_3" }, -- 50
		{ text = "Curb-biter", callback = spwGang, data = "ene_gang_black_4" }, -- 51
		{},
		{ text = "Dirty Sanchez", callback = spwGang, data = "ene_gang_mexican_1" }, -- 52
		{ text = "Cholo", callback = spwGang, data = "ene_gang_mexican_2" }, -- 53
		{ text = "Field rat", callback = spwGang, data = "ene_gang_mexican_3" }, -- 54
		{ text = "Border Bandit", callback = spwGang, data = "ene_gang_mexican_4" }, -- 55
		{},
		{ text = "Rigger (NOT WORKING?)", callback = spwGang, data = "ene_gang_russian_1" }, -- 56
		{ text = "Mudak", callback = spwGang, data = "ene_gang_russian_2" }, -- 57
		{ text = "Vodka nigger (NOT WORKING?)", callback = spwGang, data = "ene_gang_russian_3" }, -- 58
		}
	gangmenu = gangmenu or SimpleMenu:new("SPAWN HOSTILE GANGSTERS", "Call in the hoods",gangoptions)
	-- HOSTILE COP UNITS MENU INGAME
	hoscoptions = hoscoptions or {
		{ text = "Back", callback = callspawnmainmenu },
		{ text = "", is_cancel_button = true},{},
		{ text = "Hostile FBI menu", callback = callhosfbimenu },
		{ text = "Hostile SWAT menu", callback = callhoswatmenu },
		{ text = "Hostile Gangsters menu", callback = callgangmenu },
		{},
		{ text = "Gun", callback = spwPissedOfCop, data = "ene_cop_1" },
		{ text = ".45 Gun", callback = spwPissedOfCop, data = "ene_cop_2" },
		{ text = "Smg", callback = spwPissedOfCop, data = "ene_cop_3" },
		{ text = "Shotgun", callback = spwPissedOfCop, data = "ene_cop_4" },
		{ text = "Mallcop gun", callback = spwPissedOfCop, data = "ene_security_1" },
		{ text = "Mallcop gun armor", callback = spwPissedOfCop, data = "ene_security_2" },
		{ text = "Mallcop smg", callback = spwPissedOfCop, data = "ene_security_3" },
		{ text = "Secret service", callback = spwPissedOfCop, data = "ene_secret_service_1" },
		{ text = "Secret service 2", callback = spwPissedOfCop, data = "ene_secret_service_2" },
		{ text = "GenSec Security officer", callback = spwPissedOfDLCop, data = "ene_security_gensec_1" },
		{ text = "GenSec Security officer 2", callback = spwPissedOfDLCop, data = "ene_security_gensec_2" },
		}
	hoscopmenu = hoscopmenu or SimpleMenu:new("SPAWN HOSTILE COPS", "Donut attack....",hoscoptions)
	-- HOSTILE FBI UNITS MENU INGAME
	hosfbions = hosfbions or {
		{ text = "Back", callback = callspawnmainmenu },
		{ text = "", is_cancel_button = true},
		{ text = "Hostile COPS menu", callback = callhoscopmenu },
		{ text = "Hostile SWAT menu", callback = callhoswatmenu },
		{ text = "Hostile Gangsters menu", callback = callgangmenu },
		{},
		{ text = "Gun", callback = spwPissedOfCop, data = "ene_fbi_1" },
		{ text = "Assault", callback = spwPissedOfCop, data = "ene_fbi_2" },
		{ text = "Smg", callback = spwPissedOfCop, data = "ene_fbi_3" },
		{ text = "Heavy assault", callback = spwPissedOfCop, data = "ene_fbi_heavy_1" },
		{ text = "Heavy assault 2", callback = spwPissedOfCop, data = "ene_fbi_swat_1" },
		{ text = "Heavy shotgun", callback = spwPissedOfCop, data = "ene_fbi_swat_2" },
		{ text = "Shield", callback = spwPissedOfCop, data = "ene_shield_1" },
		{ text = "Sniper", callback = spwPissedOfCop, data = "ene_sniper_2" },
		}
	hosfbimenu = hosfbimenu or SimpleMenu:new("SPAWN HOSTILE FBI UNITS", "uhhh ohh....",hosfbions)
	-- HOSTILE SWAT UNITS MENU INGAME
	hoswations = hoswations or {
		{ text = "Back", callback = callspawnmainmenu },
		{ text = "", is_cancel_button = true},
		{ text = "Hostile COPS menu", callback = callhoscopmenu },
		{ text = "Hostile FBI menu", callback = callhosfbimenu },
		{ text = "Hostile Gangsters menu", callback = callgangmenu },
		{},
		{ text = "Smg", callback = spwPissedOfCop, data = "ene_swat_1" },
		{ text = "Urban camo SMG", callback = spwPissedOfCop, data = "ene_city_swat_3" },
		{ text = "Shotgun", callback = spwPissedOfCop, data = "ene_swat_2" },
		{ text = "Urban camo shotgun", callback = spwPissedOfCop, data = "ene_city_swat_2" },
		{ text = "Assault", callback = spwPissedOfCop, data = "ene_swat_heavy_1" },
		{ text = "Urban camo assault", callback = spwPissedOfCop, data = "ene_city_swat_1" },
		{ text = "Tazer", callback = spwPissedOfCop, data = "ene_tazer_1" },
		{ text = "Spook", callback = spwPissedOfCop, data = "ene_spook_1" },
		{ text = "Shield", callback = spwPissedOfCop, data = "ene_shield_2" },
		{ text = "Sniper", callback = spwPissedOfCop, data = "ene_sniper_1" },
		{ text = "Bulldozer", callback = spwPissedOfCop, data = "ene_bulldozer_1" },
		{ text = "Saiga bulldozer", callback = spwPissedOfCop, data = "ene_bulldozer_2" },
		{ text = "Urban camo bulldozer", callback = spwPissedOfCop, data = "ene_bulldozer_3" },
		}
	hoswatmenu = hoswatmenu or SimpleMenu:new("SPAWN HOSTILE SWAT UNITS", "Run for the hills.....",hoswations)
	-- SETTINGS MENU INGAME
	settings = settings or {
		{ text = "Back", callback = callspawnmainmenu },
		{ text = "", is_cancel_button = true},
		{ text = "Save settings", callback = setsaveall },
		--{ text = "Load all packages", callback = loadpack },
		{},
		{ text = "Spawn on self", callback = setself },
		{ text = "Spawn on crosshair", callback = setmouse },
		{ text = "Spawn on spawn point", callback = setspawnpoint },
		{},
		{ text = "Set enemy to follow toggle", callback = setenemyfollow},
		{ text = "Set bodyguard to follow toggle", callback = setbgfollow },
		{},
		{ text = "Enemy spawn amount", callback = callspawnnumbermenu },
		{ text = "Bodyguard spawn amount", callback = callspawnnumberbgmenu },
		{ text = "Civilians spawn amount", callback = callspawnnumbercivmenu },
		}
	settingsmenu = settingsmenu or SimpleMenu:new("SETTINGS", "..choose spawn settings.",settings)
	-- AMOUNT OF ENEMY UNITS TO SPAWN MENU
	spawnnumber = spawnnumber or {
		{ text = "Back", callback = callsettingsmenu },
		{ text = "", is_cancel_button = true},
		{ text = "10", callback = setNum, data = {["type"] = "enemy", ["amount"] = 10} },
		{ text = "9", callback = setNum, data = {["type"] = "enemy", ["amount"] = 9} },
		{ text = "8", callback = setNum, data = {["type"] = "enemy", ["amount"] = 8} },
		{ text = "7", callback = setNum, data = {["type"] = "enemy", ["amount"] = 7} },
		{ text = "6", callback = setNum, data = {["type"] = "enemy", ["amount"] = 6} },
		{ text = "5", callback = setNum, data = {["type"] = "enemy", ["amount"] = 5} },
		{ text = "4", callback = setNum, data = {["type"] = "enemy", ["amount"] = 4} },
		{ text = "3", callback = setNum, data = {["type"] = "enemy", ["amount"] = 3} },
		{ text = "2", callback = setNum, data = {["type"] = "enemy", ["amount"] = 2} },
		{ text = "1", callback = setNum, data = {["type"] = "enemy", ["amount"] = 1} },
		}
	spawnnumbermenu = spawnnumbermenu or SimpleMenu:new("ENEMY UNITS", "Amount of enemy units to spawn.",spawnnumber)
	 -- AMOUNT OF BODYGUARD UNITS TO SPAWN MENU
	spawnnumberbg = spawnnumberbg or {
		{ text = "Back", callback = callsettingsmenu },
		{ text = "", is_cancel_button = true},
		{ text = "10", callback = setNum, data = {["type"] = "bodyg", ["amount"] = 10} },
		{ text = "9", callback = setNum, data = {["type"] = "bodyg", ["amount"] = 9} },
		{ text = "8", callback = setNum, data = {["type"] = "bodyg", ["amount"] = 8} },
		{ text = "7", callback = setNum, data = {["type"] = "bodyg", ["amount"] = 7} },
		{ text = "6", callback = setNum, data = {["type"] = "bodyg", ["amount"] = 6} },
		{ text = "5", callback = setNum, data = {["type"] = "bodyg", ["amount"] = 5} },
		{ text = "4", callback = setNum, data = {["type"] = "bodyg", ["amount"] = 4} },
		{ text = "3", callback = setNum, data = {["type"] = "bodyg", ["amount"] = 3} },
		{ text = "2", callback = setNum, data = {["type"] = "bodyg", ["amount"] = 2} },
		{ text = "1", callback = setNum, data = {["type"] = "bodyg", ["amount"] = 1} },
		}
	spawnnumberbgmenu = spawnnumberbgmenu or SimpleMenu:new("SETTINGS", "Amount of bodyguard units to spawn.",spawnnumberbg)
	-- AMOUNT OF CIVILIAN UNITS TO SPAWN MENU
	spawnnumberciv = spawnnumberciv or {
		{ text = "Back", callback = callsettingsmenu },
		{ text = "", is_cancel_button = true},
		{ text = "10", callback = setNum, data = {["type"] = "civ", ["amount"] = 10} },
		{ text = "9", callback = setNum, data = {["type"] = "civ", ["amount"] = 9} },
		{ text = "8", callback = setNum, data = {["type"] = "civ", ["amount"] = 8} },
		{ text = "7", callback = setNum, data = {["type"] = "civ", ["amount"] = 7} },
		{ text = "6", callback = setNum, data = {["type"] = "civ", ["amount"] = 6} },
		{ text = "5", callback = setNum, data = {["type"] = "civ", ["amount"] = 5} },
		{ text = "4", callback = setNum, data = {["type"] = "civ", ["amount"] = 4} },
		{ text = "3", callback = setNum, data = {["type"] = "civ", ["amount"] = 3} },
		{ text = "2", callback = setNum, data = {["type"] = "civ", ["amount"] = 2} },
		{ text = "1", callback = setNum, data = {["type"] = "civ", ["amount"] = 1} },
		}
	spawnnumbercivmenu = spawnnumbercivmenu or SimpleMenu:new("SETTINGS", "Amount of civilian units to spawn.",spawnnumberciv)
	-- ROOT MENU OPTIONS
	spawnmain = spawnmain or {
		{ text = "Exit", is_cancel_button = true},
		{},
		{ text = "Spawn settings", callback = show_menu, data = settingsmenu},
		{},
		{ text = "Load level packages", callback = callloadmenu },
		{},
		{ text = "Spawn civilian animation options", callback = callcivanimenu },
		{},
		{ text = "Spawn male civilian units", callback = callcivilmmenu },
		{ text = "Spawn male civilian units 2", callback = callcivilmmenu2 },
		{ text = "Spawn female civilian units", callback = callcivilfmenu },
		{},
		{},
		{ text = "Spawn cop animation menu", callback = callcopanimenu },
		{},
		{ text = "Spawn cop bodyguards", callback = callcopmenu },
		{ text = "Spawn fbi bodyguards", callback = callfbimenu },
		{ text = "Spawn swat bodyguards", callback = callswatmenu },
		{},
		--{ text = "Spawn NPC units menu", callback = callmixunitsmenu },
		--{},
		{ text = "Spawn hostile gangsters", callback = callgangmenu },
		{ text = "Spawn hostile cops", callback = callhoscopmenu},
		{ text = "Spawn hostile fbi", callback = callhosfbimenu },
		{ text = "Spawn hostile swat", callback = callhoswatmenu },
		}
	spawnmainmenu = spawnmainmenu or SimpleMenu:new("SPAWN MENU \[HOST ONLY\]","lets mix it up a little...", spawnmain)
		-- SHOW INGAME MENU
		spawnmainmenu:show()
	else
	PlayMedia("trainer/media/effects/access.mp3")
end